/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco.blocks;

import com.mojang.serialization.MapCodec;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class CageLampBlock
extends DirectionalBlock
implements ProperWaterloggedBlock,
IWrenchable {
    public final DustParticleOptions particle;
    protected static final VoxelShape AABB_UP = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0);
    protected static final VoxelShape AABB_DOWN = Block.box((double)5.0, (double)8.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    protected static final VoxelShape AABB_EAST = Block.box((double)0.0, (double)5.0, (double)5.0, (double)8.0, (double)11.0, (double)11.0);
    protected static final VoxelShape AABB_WEST = Block.box((double)8.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0);
    protected static final VoxelShape AABB_SOUTH = Block.box((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)8.0);
    protected static final VoxelShape AABB_NORTH = Block.box((double)5.0, (double)5.0, (double)8.0, (double)11.0, (double)11.0, (double)16.0);

    public CageLampBlock(BlockBehaviour.Properties props, Vector3f color) {
        super(props);
        this.particle = new DustParticleOptions(color, 0.3f);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.INVERTED, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.UP)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return this.withWater((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)ctx.getClickedFace())).setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(ctx.getLevel().hasSignal(ctx.getClickedPos(), ctx.getClickedFace()))), ctx);
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext ctx) {
        return switch ((Direction)state.getValue((Property)BlockStateProperties.FACING)) {
            default -> throw new MatchException(null, null);
            case Direction.UP -> AABB_UP;
            case Direction.DOWN -> AABB_DOWN;
            case Direction.EAST -> AABB_EAST;
            case Direction.WEST -> AABB_WEST;
            case Direction.SOUTH -> AABB_SOUTH;
            case Direction.NORTH -> AABB_NORTH;
        };
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState updateShape(BlockState state, Direction from, BlockState neighbor, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        this.updateWater(level, state, pos);
        return !this.canSurvive(state, (LevelReader)level, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, from, neighbor, level, pos, neighborPos);
    }

    public FluidState getFluidState(BlockState pState) {
        return this.fluidState(pState);
    }

    public static boolean shouldBeLit(BlockState state, Level level, BlockPos pos) {
        Direction attach = ((Direction)state.getValue((Property)BlockStateProperties.FACING)).getOpposite();
        return (Boolean)state.getValue((Property)BlockStateProperties.INVERTED) ^ level.hasSignal(pos.relative(attach), attach);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighbor, BlockPos neighborPos, boolean bool) {
        Direction face = (Direction)state.getValue((Property)BlockStateProperties.FACING);
        if (pos.relative(face.getOpposite()).equals((Object)neighborPos)) {
            BlockState blockState = this.toggle(state, level, pos);
        }
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player entity, BlockHitResult hitResult) {
        BlockState next = this.toggle((BlockState)state.cycle((Property)BlockStateProperties.INVERTED), level, pos);
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        float pitch = (Boolean)next.getValue((Property)BlockStateProperties.INVERTED) != false ? 0.6f : 0.5f;
        level.playSound((Player)null, pos, SoundEvents.COMPARATOR_CLICK, SoundSource.BLOCKS, 0.3f, pitch);
        return InteractionResult.CONSUME;
    }

    private BlockState toggle(BlockState state, Level level, BlockPos pos) {
        if (level.isClientSide) {
            this.makeParticle(state, (LevelAccessor)level, pos);
        }
        BlockState next = (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(CageLampBlock.shouldBeLit(state, level, pos)));
        level.setBlock(pos, next, 3);
        return next;
    }

    private void makeParticle(BlockState state, LevelAccessor level, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)BlockStateProperties.FACING);
        float x = (float)pos.getX() + 0.5f + 0.1f * (float)direction.getStepX();
        float y = (float)pos.getY() + 0.5f + 0.1f * (float)direction.getStepY();
        float z = (float)pos.getZ() + 0.5f + 0.1f * (float)direction.getStepZ();
        level.addParticle((ParticleOptions)this.particle, (double)x, (double)y, (double)z, 0.0, 0.0, 0.0);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.LIT, BlockStateProperties.INVERTED, BlockStateProperties.FACING, WATERLOGGED});
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return CageLampBlock.canSurvive(level, pos, (Direction)state.getValue((Property)BlockStateProperties.FACING));
    }

    public static boolean canSurvive(LevelReader level, BlockPos pos, Direction facing) {
        BlockPos opposite = pos.relative(facing.getOpposite());
        return Block.canSupportCenter((LevelReader)level, (BlockPos)opposite, (Direction)facing.getOpposite());
    }

    protected MapCodec<? extends DirectionalBlock> codec() {
        return null;
    }
}

