/*
 * Decompiled with CFR 0.152.
 */
package io.github.ennuil.ok_zoomer.utils;

import io.github.ennuil.ok_zoomer.config.ConfigEnums;
import io.github.ennuil.ok_zoomer.config.OkZoomerConfigManager;
import io.github.ennuil.ok_zoomer.key_binds.ZoomKeyBinds;
import io.github.ennuil.ok_zoomer.utils.ModUtils;
import io.github.ennuil.ok_zoomer.utils.Portals;
import io.github.ennuil.ok_zoomer.zoom.Zoom;
import java.util.function.Predicate;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_746;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZoomUtils {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Ok Zoomer");
    public static final class_370.class_9037 TOAST_ID = new class_370.class_9037();
    public static final class_6862<class_1792> ZOOM_DEPENDENCIES_TAG = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)ModUtils.id("zoom_dependencies"));
    public static int zoomStep = 0;
    private static Predicate<class_746> hasSpyglass = player -> player.method_68878();
    private static boolean safeSmartOcclusion = false;
    private static boolean modifyPipeline = false;

    public static void changeZoomDivisor(boolean increase) {
        if (OkZoomerConfigManager.CONFIG.features.scrollingMode.value() == ConfigEnums.ScrollingModes.EXPONENTIAL) {
            class_310 minecraft = class_310.method_1551();
            int scrollBase = (Integer)OkZoomerConfigManager.CONFIG.zoomValues.scrollBase.value();
            int scrollResolution = (Integer)OkZoomerConfigManager.CONFIG.zoomValues.scrollResolution.value();
            int upperScrollStep = (Integer)OkZoomerConfigManager.CONFIG.zoomValues.scrollStepLimit.value();
            int lowerScrollStep = 0;
            int lastZoomStep = zoomStep;
            zoomStep = increase ? Math.min(zoomStep + 1, upperScrollStep) : Math.max(zoomStep - 1, -lowerScrollStep);
            double divisor = 1.0;
            if (zoomStep != 0) {
                divisor = Math.pow(scrollBase, (double)zoomStep / (double)scrollResolution);
                Zoom.setZoomDivisor(divisor);
            } else {
                Zoom.setZoomDivisor(1.0);
            }
            if (lastZoomStep != zoomStep && ((Boolean)OkZoomerConfigManager.CONFIG.tweaks.scrollSounds.value()).booleanValue()) {
                minecraft.field_1724.method_5783(Portals.getScrollSound(), 1.0f, 1.0f);
            }
            if (((Boolean)OkZoomerConfigManager.CONFIG.tweaks.debugScrolling.value()).booleanValue()) {
                minecraft.field_1724.method_7353((class_2561)class_2561.method_43470((String)(zoomStep + " - " + divisor)), true);
            }
        } else {
            double zoomDivisor = (Double)OkZoomerConfigManager.CONFIG.legacyScrollValues.zoomDivisor.value();
            double minimumZoomDivisor = (Double)OkZoomerConfigManager.CONFIG.legacyScrollValues.minimumZoomDivisor.value();
            double maximumZoomDivisor = (Double)OkZoomerConfigManager.CONFIG.legacyScrollValues.maximumZoomDivisor.value();
            int upperScrollStep = (Integer)OkZoomerConfigManager.CONFIG.legacyScrollValues.upperScrollSteps.value();
            int lowerScrollStep = (Integer)OkZoomerConfigManager.CONFIG.legacyScrollValues.lowerScrollSteps.value();
            int n = zoomStep = increase ? Math.min(zoomStep + 1, upperScrollStep) : Math.max(zoomStep - 1, -lowerScrollStep);
            if (zoomStep > 0) {
                Zoom.setZoomDivisor(zoomDivisor + (maximumZoomDivisor - zoomDivisor) / (double)upperScrollStep * (double)zoomStep);
            } else if (zoomStep == 0) {
                Zoom.setZoomDivisor(zoomDivisor);
            } else {
                Zoom.setZoomDivisor(zoomDivisor + (minimumZoomDivisor - zoomDivisor) / (double)lowerScrollStep * (double)(-zoomStep));
            }
        }
    }

    public static void resetZoomDivisor(boolean userPrompted) {
        if (!userPrompted && !((Boolean)OkZoomerConfigManager.CONFIG.tweaks.forgetZoomDivisor.value()).booleanValue()) {
            return;
        }
        if (OkZoomerConfigManager.CONFIG.features.scrollingMode.value() == ConfigEnums.ScrollingModes.EXPONENTIAL) {
            int scrollBase = (Integer)OkZoomerConfigManager.CONFIG.zoomValues.scrollBase.value();
            int scrollResolution = (Integer)OkZoomerConfigManager.CONFIG.zoomValues.scrollResolution.value();
            zoomStep = (Integer)OkZoomerConfigManager.CONFIG.zoomValues.defaultScrollStep.value();
            Zoom.setZoomDivisor(Math.pow(scrollBase, (double)zoomStep / (double)scrollResolution));
        } else {
            zoomStep = 0;
            Zoom.setZoomDivisor((Double)OkZoomerConfigManager.CONFIG.legacyScrollValues.zoomDivisor.value());
        }
    }

    public static void keepZoomStepsWithinBounds() {
        boolean isExponential = OkZoomerConfigManager.CONFIG.features.scrollingMode.value() == ConfigEnums.ScrollingModes.EXPONENTIAL;
        int upperScrollStep = isExponential ? (Integer)OkZoomerConfigManager.CONFIG.zoomValues.scrollStepLimit.value() : (Integer)OkZoomerConfigManager.CONFIG.legacyScrollValues.upperScrollSteps.value();
        int lowerScrollStep = isExponential ? 0 : (Integer)OkZoomerConfigManager.CONFIG.legacyScrollValues.lowerScrollSteps.value();
        zoomStep = class_3532.method_15340((int)zoomStep, (int)(-lowerScrollStep), (int)upperScrollStep);
    }

    public static void unbindConflictingKey(class_310 client, boolean userPrompted) {
        if (ZoomKeyBinds.ZOOM_KEY.method_1427()) {
            if (client.field_1690.field_1879.method_1427()) {
                if (userPrompted) {
                    LOGGER.info("[Ok Zoomer] The \"Save Toolbar Activator\" keybind was occupying C! Unbinding...");
                    client.method_1566().method_1999((class_368)class_370.method_29047((class_310)client, (class_370.class_9037)TOAST_ID, (class_2561)class_2561.method_43471((String)"toast.ok_zoomer.title"), (class_2561)class_2561.method_43471((String)"toast.ok_zoomer.unbind_conflicting_key.success")));
                } else {
                    LOGGER.info("[Ok Zoomer] The \"Save Toolbar Activator\" keybind was occupying C! Unbinding... This process won't be repeated until specified in the config.");
                }
                client.field_1690.field_1879.method_1422(class_3675.field_16237);
                client.field_1690.method_1640();
                class_304.method_1426();
            } else {
                LOGGER.info("[Ok Zoomer] No conflicts with the \"Save Toolbar Activator\" keybind were found!");
                if (userPrompted) {
                    client.method_1566().method_1999((class_368)class_370.method_29047((class_310)client, (class_370.class_9037)TOAST_ID, (class_2561)class_2561.method_43471((String)"toast.ok_zoomer.title"), (class_2561)class_2561.method_43471((String)"toast.ok_zoomer.unbind_conflicting_key.no_conflict")));
                }
            }
        }
    }

    public static boolean hasSpyglass(class_746 player) {
        return hasSpyglass.test(player);
    }

    public static void addSpyglassProvider(Predicate<class_746> provider) {
        hasSpyglass = hasSpyglass.or(provider);
    }

    public static void enableSafeSmartOcclusion() {
        safeSmartOcclusion = true;
    }

    public static boolean hasSmartOcclusion() {
        return (Boolean)OkZoomerConfigManager.CONFIG.tweaks.smartOcclusion.value() != false && safeSmartOcclusion;
    }

    public static boolean canSeeDistantEntities() {
        return switch ((ConfigEnums.SeeDistantEntitiesModes)OkZoomerConfigManager.CONFIG.tweaks.seeDistantEntities.value()) {
            default -> throw new MatchException(null, null);
            case ConfigEnums.SeeDistantEntitiesModes.SAFE -> safeSmartOcclusion;
            case ConfigEnums.SeeDistantEntitiesModes.ON -> true;
            case ConfigEnums.SeeDistantEntitiesModes.OFF -> false;
        };
    }

    public static boolean shouldModifyPipeline() {
        return modifyPipeline;
    }

    public static void setModifyPipeline(boolean modifyPipeline) {
        ZoomUtils.modifyPipeline = modifyPipeline;
    }
}

